
#ifndef _1_CRYS_SEP_ATP_Defines_h_H
#define _1_CRYS_SEP_ATP_Defines_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Nov 26 11:21:17 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_Defines.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Global Data **************************/
extern CRYSError_t      TST_ATP_Error;

/************************ Defines ******************************/
#define TESTPASS 	                     0
#define TESTFAIL 	                     1
#define TST_ENCRYPT						 0 
#define TST_DECRYPT                      1
#define TST_FUNC_STRING_LEN              100
#define TST_NAME_STRING_LEN              150
#define TST_INTERNAL_KG                  0
#define TST_NO_INTERNAL_KEYGEN           1
#define TST_ZERO_DATA 	                 0
#define TST_MAX_DATA_VEC_SIZE_IN_BYTS    1536

/*AES*/
/*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_AES_BLOCK_SIZE_IN_BYTS 16
#define TST_CBC_MAC_SIZE 16
#define TST_USE_SECRETKEY_TESTS 0

/*DES*/
/*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_DES_BLOCK_SIZE_IN_BYTS 8

/*HASH*/
/*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_HASH_BLOCK_SIZE_IN_BYTS 16

/*RC4*/
/*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS 1


/*RSA*/
/*----------------------------------------------------------------------*/
#define TST_NO_CRT 	 0
#define TST_CRT_MODE 1
#define TST_MAX_SINGLE_RSA_SIGN_BLOCK_SIZE_IN_BYTS 16
#define TST_MAX_MOD_SIZE_IN_BYTES 256
#define TST_MAX_PRVT_EXP_SIZE_IN_BYTES 256
#define TST_MAX_PUB_EXP_SIZE_IN_BYTES 3


/*ECC*/
/*---------------------------------------------------------------------*/
#define TST_MAX_SINGLE_ECC_SIGN_BLOCK_SIZE_IN_BYTS 16
#define TST_MAX_ECC_KEY_SIZE_BYTES 256

/*Diffie Hellman*/
/*---------------------------------------------------------------------*/
#define TST_MAX_DH_KEY_SIZE             1024
#define TST_DH_GET_SECRET_KEY_ASN1      0
#define TST_DH_HYBRID_MODE              1
#define TST_DH_NON_HYBRID_MODE          0


#ifdef __cplusplus
}
#endif
 
#endif

